<?php

namespace App\Controllers;

use App\Libraries\CIAuth;
use App\Libraries\OneSignal;

use App\Models\PanelModel;
use App\Models\UsersModel;

class PanelController extends BaseController {
    
    public function __construct(){
        $panelModel = new PanelModel();
        $this->settings = $panelModel->getSettings();
    }
    
    public function index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $categoryModel = new \App\Models\CategoryModel();
        $categoryTotalCount = $categoryModel->countAll();
        
        $countriesModel = new \App\Models\CountriesModel();
        $countriesTotalCount = $countriesModel->countAll();
        
        $radioModel = new \App\Models\RadioModel();
        $radioTotalCount = $radioModel->countAll();
        
        $podcastModel = new \App\Models\PodcastModel();
        $podcastTotalCount = $podcastModel->countAll();
        
        $episodeModel = new \App\Models\EpisodeModel();
        $episodeTotalCount = $episodeModel->countAll();
        
        $reportsModel = new \App\Models\ReportsModel();
        $reportsTotalCount = $reportsModel->countAll();
        
        $usersModel = new \App\Models\UsersModel();
        $usersTotalCount = $usersModel->countAll();
        
        $adminModel = new \App\Models\AdminModel();
        $adminTotalCount = $adminModel->countAll();

        $countStr = '';
        $no_data_status = false;
        $count = $monthCount = 0;
        $monthStr = '';
        
        for ($mon = 1; $mon <= 12; $mon++) {
        
            $monthCount++;
            
            $year = $this->request->getGet('filterByYear') ?? date('Y');
            
            $month = date('M', mktime(0, 0, 0, $mon, 1, $year));
            $userModel = new UsersModel();
            $totalcount = $userModel->getMonthlyRegistrations($mon, $year);
            $countStr.="$totalcount, ";
            $monthStr.="'".$month."', ";
            
            if ($totalcount == 0) {
                $count++;
            }
        }
        
        $data = [
            'pageTitle' => 'Dashboard',
            'currentFile' => 'dashboard',
            
            'categoryTotalCount' => $categoryTotalCount,
            'countriesTotalCount' => $countriesTotalCount,
            'radioTotalCount' => $radioTotalCount,
            'podcastTotalCount' => $podcastTotalCount,
            'episodeTotalCount' => $episodeTotalCount,
            'reportsTotalCount' => $reportsTotalCount,
            'usersTotalCount' => $usersTotalCount,
            'adminTotalCount' => $adminTotalCount,
            
            'monthStr' => $monthStr,
            'countStr' => $countStr,
            'no_data_status' => $no_data_status
        ];
        $data['settings'] = $this->settings;
        $data['result'] = $reportsModel->orderBy('id', 'DESC')->limit(8)->findAll();
        
        return view('dashboard', $data);
    }
    
    public function urls_index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $data = [
            'pageTitle' => 'Urls',
            'currentFile' => 'urls'
        ];
        $data['settings'] = $this->settings;
        return view('urls', $data);
    }

    public function policy_index(){
        $data = [
            'pageTitle' => 'Privacy Policy',
            'currentFile' => 'policy'
        ];
        $data['settings'] = $this->settings;
        return view('policy', $data);
    }
    
    public function terms_index(){
        $data = [
            'pageTitle' => 'Terms & Conditions',
            'currentFile' => 'terms'
        ];
        $data['settings'] = $this->settings;
        return view('policy', $data);
    }
}